﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class LabOrders : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int statusId;
            if (int.TryParse(Request.QueryString["statusId"], out statusId)) 
            {
                //check if it's in-process or completed questionnaire(now in new status)
                if (statusId == 6)
                {
                    GridViewEFRLabOrders.Columns[0].Visible = true;
                    GridViewEFRLabOrders.Columns[1].Visible = false;
                    GridViewEFRLabOrders.Columns[2].Visible = true;
                    GridViewEFRLabOrders.Columns[3].Visible = true;
                    GridViewEFRLabOrders.Columns[4].Visible = true;
                    GridViewEFRLabOrders.Columns[5].Visible = false;
                    GridViewEFRLabOrders.Columns[6].Visible = false;
                    GridViewEFRLabOrders.Columns[7].Visible = false;
                    GridViewEFRLabOrders.Columns[8].Visible = true;
                    GridViewEFRLabOrders.Columns[9].Visible = true;
                    GridViewEFRLabOrders.Columns[10].Visible = false;
                }
                //survey type is not shown here

                if (statusId == 1 || statusId == 3)
                {
                    SetDropDownFilterBy();

                    GridViewEFRLabOrders.Columns[0].Visible = true;
                    GridViewEFRLabOrders.Columns[1].Visible = true;
                    GridViewEFRLabOrders.Columns[2].Visible = true;
                    GridViewEFRLabOrders.Columns[3].Visible = true;
                    GridViewEFRLabOrders.Columns[4].Visible = true;
                    GridViewEFRLabOrders.Columns[5].Visible = true;
                    GridViewEFRLabOrders.Columns[6].Visible = false;
                    GridViewEFRLabOrders.Columns[7].Visible = false;
                    GridViewEFRLabOrders.Columns[8].Visible = true;
                    GridViewEFRLabOrders.Columns[9].Visible = true;
                    GridViewEFRLabOrders.Columns[10].Visible = true;
                }

                if (statusId == 9)
                {
                    SetDropDownFilterBy();

                    GridViewEFRLabOrders.Columns[0].Visible = true;
                    GridViewEFRLabOrders.Columns[1].Visible = true;
                    GridViewEFRLabOrders.Columns[2].Visible = true;
                    GridViewEFRLabOrders.Columns[3].Visible = true;
                    GridViewEFRLabOrders.Columns[4].Visible = true;
                    GridViewEFRLabOrders.Columns[5].Visible = true;
                    GridViewEFRLabOrders.Columns[6].Visible = false;
                    GridViewEFRLabOrders.Columns[7].Visible = true;
                    GridViewEFRLabOrders.Columns[8].Visible = true;
                    GridViewEFRLabOrders.Columns[9].Visible = true;
                    GridViewEFRLabOrders.Columns[10].Visible = true;
                }
                if (statusId == 2)
                {
                    GridViewEFRLabOrders.Columns[0].Visible = true;
                    GridViewEFRLabOrders.Columns[1].Visible = true;
                    GridViewEFRLabOrders.Columns[2].Visible = true;
                    GridViewEFRLabOrders.Columns[3].Visible = true;
                    GridViewEFRLabOrders.Columns[4].Visible = true;
                    GridViewEFRLabOrders.Columns[5].Visible = true;
                    GridViewEFRLabOrders.Columns[6].Visible = true;
                    GridViewEFRLabOrders.Columns[7].Visible = false;
                    GridViewEFRLabOrders.Columns[8].Visible = true;
                    GridViewEFRLabOrders.Columns[9].Visible = true;
                    GridViewEFRLabOrders.Columns[10].Visible = true;
                }
                if (statusId == 11)
                {
                    SetDropDownFilterBy();

                    GridViewEFRLabOrders.Columns[0].Visible = true;
                    GridViewEFRLabOrders.Columns[1].Visible = true;
                    GridViewEFRLabOrders.Columns[2].Visible = true;
                    GridViewEFRLabOrders.Columns[3].Visible = true;
                    GridViewEFRLabOrders.Columns[4].Visible = true;
                    GridViewEFRLabOrders.Columns[5].Visible = true;
                    GridViewEFRLabOrders.Columns[6].Visible = true;
                    GridViewEFRLabOrders.Columns[7].Visible = false;
                    GridViewEFRLabOrders.Columns[8].Visible = true;
                    GridViewEFRLabOrders.Columns[9].Visible = true;
                    GridViewEFRLabOrders.Columns[10].Visible = true;
                }
            }

            HiddenFieldClearFlag.Value = "0";
        }
    }

    public void SetDropDownFilterBy()
    {
        DropDownFilterBy.Visible = true;
        LabelSearchCriteria.Text = "Filter by:";
        LabelSearchCriteria.AssociatedControlID = DropDownFilterBy.ID;
        //GridViewEFRLabOrders.DataSourceID = "ObjectDataSourceEFRLabOrdersMultipleSearch";
    }

    public void LabOrders_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRLabOrders.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRLabOrders.SelectedValue);
            //calling the right page for different order lab order types
            Label orderType = GridViewEFRLabOrders.SelectedRow.FindControl("LabelOrderType") as Label;
            if (orderType != null)
            {
                if (orderType.Text.Equals("Biological Monitoring"))

                    Response.Redirect(string.Format("LabOrder.aspx?activityId={0}", id));
                else

                    Response.Redirect(string.Format("FragLabOrder.aspx?activityId={0}", id));
            }
            
        
        }

    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = String.Empty;
        HiddenFieldClearFlag.Value = "1";

    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridViewEFRLabOrders.PageIndex = 0; 

        if( DropDownFilterBy.Visible && string.IsNullOrEmpty(DropDownFilterBy.SelectedValue))
        {
            TextBoxSearchCriteria.Text = "";
            HiddenFieldClearFlag.Value = "0";
        }
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "New";
    }

    public override string AppObjectCode()
    {
        return "EFR LABORDERS";
    }
}
